import * as React from 'react';
import { useSelector } from 'react-redux';
import { Spin } from 'antd';

import { cn } from 'helpers/className/className';

import { isPageDataLoadingByQueryId } from 'selectors/logs/isPageDataLoadingByQueryId/isPageDataLoadingByQueryId';

import { Filters } from 'components/Filters/Filters';
import { LogsTable } from 'components/LogsTable/LogsTable';
import { SqlCode } from 'components/SqlCode/SqlCode';

import { getLogsSql } from 'selectors/logs/getLogsSql/getLogsSql';

import './Logs.css';

const cls = cn('logs');

interface LogsProps {
    abortFetchLogsRequest: () => void;
    getFetchLogsRequestSignal: () => AbortSignal;
}

export const Logs = React.memo(function (props: LogsProps) {
    const sql = useSelector(getLogsSql);
    const isPageDataLoadingByQueryIdValue = useSelector(isPageDataLoadingByQueryId);
    const { abortFetchLogsRequest, getFetchLogsRequestSignal } = props;

    if (isPageDataLoadingByQueryIdValue) {
        return (
            <div className={cls({ loading: true })}>
                <Spin />
            </div>
        );
    }

    return (
        <div className={cls()}>
            <Filters
                className={cls('filters')}
                abortFetchLogsRequest={abortFetchLogsRequest}
                getFetchLogsRequestSignal={getFetchLogsRequestSignal}
            />
            {sql && <SqlCode className={cls('sql-code')} />}
            <LogsTable
                className={cls('table')}
                getFetchLogsRequestSignal={getFetchLogsRequestSignal}
            />
        </div>
    );
});
