import { FormSchema } from 'schema/form/FormSchema';
import { UIFilterFormSchema } from 'schema/ui/UISchema';

import { getFromDateForApi } from 'helpers/date/getFromDateForApi/getFromDateForApi';
import { getToDateForApi } from 'helpers/date/getToDateForApi/getToDateForApi';

export function getFilterFormFromUI(
    filterForm: UIFilterFormSchema & {
        logType: string;
    },
): FormSchema {
    const from = getFromDateForApi(filterForm.from);
    const to = getToDateForApi(filterForm.to);

    let result: FormSchema = {
        logType: filterForm.logType,
        form: {
            conditions: filterForm.conditions,
            fields: filterForm.fields || [],
            from,
            limit: filterForm.limit || 100,
            offset: 0,
            reverseOrder: Boolean(filterForm.reverseOrder),
            showTraceIdRelated: Boolean(filterForm.showTraceIdRelated),
            to,
        },
    };

    if (filterForm.showStats) {
        result.form.showStats = true;
        result.form.sortByCount = Boolean(filterForm.sortByCount);
        result.form.logTimeGroupBy = filterForm.logTimeGroupBy;
    }

    return result;
}
