import moment from 'moment';

import { FormSchema } from 'schema/form/FormSchema';

import { DATE_SHOW_LOGS_API_FORMAT } from 'enums/date';

export function getSavedFormFromOldFormatHash(hash: string): Optional<FormSchema> {
    let params = hash.split(',');

    if (params[0] === 'dbName') {
        params.shift();
    }

    let logType = params.shift();

    if (params.length === 0) {
        return;
    }

    let from = moment(params.shift());
    let to = moment(params.shift());

    let savedForm: FormSchema = {
        logType: logType || '',
        form: {
            conditions: {},
            fields: [],
            from: from.format(DATE_SHOW_LOGS_API_FORMAT),
            limit: 100,
            offset: 0,
            reverseOrder: false,
            showTraceIdRelated: false,
            to: to.format(DATE_SHOW_LOGS_API_FORMAT),
        },
    };

    if (params[0] === 'showStats') {
        params.shift();
        savedForm.form.showStats = true;
        savedForm.form.logTimeGroupBy = params.shift();
        savedForm.form.sortByCount = params.shift() === 'sortByCount';
    }

    let isBool = function (value: string): boolean {
        return value === 'true' || value === 'false';
    };

    if (isBool(params[0])) {
        savedForm.form.showTraceIdRelated = params.shift() === 'true';
    }

    if (isBool(params[0])) {
        savedForm.form.reverseOrder = params.shift() === 'true';
    }

    let nextValue = params.shift();
    let match = nextValue && nextValue.match(/^(\d)+:(\d+)$/);
    let limit;
    let offset;

    if (match) {
        limit = Number(match[2]);
        offset = limit * (Number(match[1]) - 1);
    }

    if (limit) {
        savedForm.form.limit = limit;
    }

    if (offset) {
        savedForm.form.offset = offset;
    }

    let columnCount = Number(params.shift());
    let fields = [];
    for (let i = 0; i < columnCount; i++) {
        let column = params.shift();

        if (column) {
            fields.push(column);
        }
    }

    savedForm.form.fields = fields;

    let conditions: Dict<string> = {};
    for (let i = 0; i < params.length; i = i + 2) {
        conditions[params[i]] = decodeURIComponent(params[i + 1]);
    }

    savedForm.form.conditions = conditions;

    return savedForm;
}
