import { UIFilterFormSchema } from 'schema/ui/UISchema';

export function validateFilterForm(filterForm: UIFilterFormSchema): string | undefined {
    if (filterForm.showStats && filterForm.fields) {
        if (filterForm.fields.length > 3) {
            return 'You can choose not more than 3 columns to group by stats';
        }

        if (
            filterForm.logTimeGroupBy !== undefined &&
            !filterForm.fields.some((x) => {
                return x === 'log_time' || x === 'datetime' || x === 'time_received' || x === 'binlog_time';
            })
        ) {
            return 'You should choose log_time or datetime column to group by it';
        }
    }
}
