import { StateSchema } from 'schema/state/StateSchema';

export function getDownloadLogsUrl(savedForm: StateSchema['savedForm']): string {
    if (!savedForm) {
        return '';
    }

    return `/logviewer/filterXls/${savedForm.logType}?form=${encodeURIComponent(
        JSON.stringify(savedForm.form),
    )}&rnd=${Math.random()}`;
}
