import * as React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';

import { ClientRequest } from 'network/ClientRequest';
import { createReduxStore } from 'state/createReduxStore/createReduxStore';

import { StateSchema } from 'schema/state/StateSchema';
import { UIPanelType } from 'schema/ui/UISchema';

import { Page } from 'components/Page/Page';

import 'antd/dist/antd.css';
import './index.css';

import 'core-js/stable';
import 'regenerator-runtime/runtime';

const request = new ClientRequest();
const initialState: StateSchema = {
    ui: {
        filterForm: {
            conditions: {},
        },
        viewInfo: {},
        selectedPanel: UIPanelType.Home,
        historyPanel: {},
        isSqlBlockVisible: false,
        hiddenColumns: {},
    },
};
const store = createReduxStore(initialState, request);

ReactDOM.render(
    <React.StrictMode>
        <Provider store={store}>
            <Page />
        </Provider>
    </React.StrictMode>,
    document.getElementById('root'),
);

// @ts-ignore
if (module.hot) {
    // @ts-ignore
    module.hot.accept();
}
