import { StateSchema } from 'schema/state/StateSchema';
import { UIFilterFormSchema } from 'schema/ui/UISchema';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';

export function mergeStateUIFilterForm(state: StateSchema, payload: Partial<UIFilterFormSchema>): StateSchema {
    let form = getUIFilterForm(state);

    return mergeStateUI(state, {
        filterForm: {
            ...form,
            ...payload,
        },
    });
}
