export interface RequestOptions {
    headers?: Dict<string>;
    retries?: number;
    parseJSON?: boolean;
    timeout?: number;
}


export interface FetchRequestOptions extends RequestOptions {
    options?: RequestInit;
    isText?: boolean;
}

export type RequestMethod = 'POST' | 'GET';

export interface RequestInterface {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    get<T>(url: string, options?: FetchRequestOptions): Promise<T>;

    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    post<T>(url: string, data: any, options?: FetchRequestOptions): Promise<T>;
}
