export interface DefaultFormFilterSchema {
    conditions: Dict<string>;
    fields: string[];
    limit: number;
    logTimeGroupBy?: string;
    offset: number;
    reverseOrder: boolean;
    showStats?: boolean;
    showTraceIdRelated: boolean;
    sortByCount?: boolean;
}

export interface FormFiltersSchema extends DefaultFormFilterSchema {
    from: string; // Дата вида 20210420T000000
    to: string; // Дата вида 20210420T000000
}

export interface HistoryFiltersSchema extends DefaultFormFilterSchema {
    from: number[]; // Дата вида [2021, 4, 29, 0, 0, 10]
    to: number[]; // Дата вида [2021, 4, 29, 0, 0, 10]
}

export interface FormSchema {
    logType: string;
    form: FormFiltersSchema;
}
