import { HistoryFiltersSchema } from 'schema/form/FormSchema';
import { LogDataSchema } from 'schema/logs/LogDataSchema';

export interface HistoryItemSchema {
    queryId: string;
    name: string;
    logName: string;
    status: HistoryItemStatus;
    startTime: number;
    // executionTime : number;
    // request : null,
    // "response" : null,
    favourite: boolean;
}

export enum HistoryItemStatus {
    OK = 'OK',
    FAIL = 'FAIL',
    RUNNING = 'RUNNING',
    UNKNOWN = 'UNKNOWN',
}

export type HistoryRequestsList = HistoryItemSchema[];

export interface HistorySchema {
    isLoading: boolean;
    isLoadNextChunkButtonHidden?: boolean;
    isNextChunkLoading: boolean;
    requestsList: HistoryRequestsList;
    startBefore?: number;
    limit: number;
}

export interface HistoryRequestSchema {
    response: LogDataSchema;
    request: HistoryFiltersSchema;
    logName: string;
}
