import { FormSchema } from 'schema/form/FormSchema';
import { HistorySchema } from 'schema/history/HistorySchema';
import { LogDataSchema } from 'schema/logs/LogDataSchema';
import { LogsConfigSchema } from 'schema/logs/LogsConfigSchema';
import { UISchema } from 'schema/ui/UISchema';

export interface StateSchema {
    /**
     * Список табличек с набором их колонок
     */
    logsConfig?: LogsConfigSchema;

    /**
     * Данные для таблицы
     */
    logs?: LogDataSchema;

    isPageDataLoadingByQueryId?: boolean;

    history?: HistorySchema;

    /**
     * Форма с данными фильтрации для таблички:
     * получаем ее из урла при первом открытии
     * или выставляем после нажатия "Show"
     */
    savedForm?: FormSchema;

    ui: UISchema;
}
