export interface UIFilterFormSchema {
    conditions: Dict<string>;
    fields?: string[]; // Набор колонок, которые показываем
    from?: string;
    limit?: number; // Page size в интерфейсе
    logTimeGroupBy?: string;
    logType?: string;
    reverseOrder?: boolean;
    showStats?: boolean;
    showTraceIdRelated?: boolean;
    sortByCount?: boolean;
    to?: string;
    uncollapsedValues?: boolean;
    error?: string;
}

type UIViewInfoSchema = Dict<string>;

export interface UIHistoryPanelSchema {
    selectedQueryId?: string;
}

export interface UISchema {
    selectedPanel: UIPanelType;
    historyPanel: UIHistoryPanelSchema;
    filterForm: UIFilterFormSchema;
    viewInfo: UIViewInfoSchema;
    isSqlBlockVisible: boolean;
    hiddenColumns: Dict<boolean>;
    preparingToShareQueryId?: string;
}

export enum UIPanelType {
    Home = 'Home',
    History = 'History',
    Favourites = 'Favourites',
    Documentation = 'Documentation',
}
