import { StateSchema } from 'schema/state/StateSchema';

import { getLogConfig } from 'selectors/logs/getLogConfig/getLogConfig';

export function isShowAllTraceIdVisible(state: StateSchema, logName?: string): boolean {
    const logConfig = getLogConfig(state, logName);

    if (!logConfig || !logConfig.traceIdColumn) {
        return false;
    }

    const traceIdCol = logConfig.columns.find((val) => val.name === logConfig.traceIdColumn);

    return traceIdCol !== null && !traceIdCol?.strictlyHidden;
}
