import { createService } from 'state/createService/createService';

import { mergeStateUIViewInfo } from 'mutators/mergeStateUIViewInfo/mergeStateUIViewInfo';

import { getUIFilterFormUncollapsedValues } from 'selectors/ui/getUIFilterFormUncollapsedValues/getUIFilterFormUncollapsedValues';
import { getUIViewInfo } from 'selectors/ui/getUIViewInfo/getUIViewInfo';

export const changeCollapse = createService(async function changeCollapse(
    { cellId }: { cellId: string },
    { setState, getState },
) {
    let state = getState();
    let cellViewInfo = getUIViewInfo(state)[cellId];
    if (cellViewInfo === undefined) {
        if (getUIFilterFormUncollapsedValues(state)) {
            cellViewInfo = 'full';
        } else {
            cellViewInfo = 'collapse';
        }
    }

    let changes: Dict<string> = {};

    if (cellViewInfo === 'collapse') {
        changes[cellId] = 'full';
    } else {
        changes[cellId] = 'collapse';
    }

    setState(mergeStateUIViewInfo(state, changes));
});
