import { createService } from 'state/createService/createService';

import { FormSchema } from 'schema/form/FormSchema';
import { LogDataSchema } from 'schema/logs/LogDataSchema';

import { mergeState } from 'mutators/mergeState/mergeState';

import { showMessage } from 'helpers/notification/showMessage/showMessage';
import { formatUrlHash } from 'helpers/url/formatUrlHash/formatUrlHash';

import { EMPTY_LOGS } from 'enums/logs';

export const fetchLogs = createService(async function fetchLogs(
    { signal, input }: { signal?: AbortSignal, input: FormSchema }, { setState, getState, request }
) {
    try {
        let data = await request.get<LogDataSchema>(
            '/logviewer/filter/' + input.logType + `?prettify=true&form=${encodeURIComponent(JSON.stringify(input.form))}`,
            {
                options: { signal }
            }
        );

        location.hash = formatUrlHash(input);

        if (data.error) {
            setState(
                mergeState(getState(), {
                    logs: {
                        ...EMPTY_LOGS,
                        error: `${data.error}, reqid=${data.reqid || ''}`,
                        fetchLogsFinishTime: Date.now()
                    },
                    savedForm: input,
                }),
            );

            return;
        }

        setState(
            mergeState(getState(), {
                logs: {
                    ...data,
                    fetchLogsFinishTime: Date.now()
                },
                savedForm: input,
            }),
        );
    } catch (e) {
        showMessage('Something went wrong with api request', 'error');
        setState(
            mergeState(getState(), {
                logs: {
                    ...EMPTY_LOGS,
                    fetchLogsFinishTime: Date.now()
                }
            }),
        );
    }
});
