import { createService } from 'state/createService/createService';

import { HistoryRequestSchema } from 'schema/history/HistorySchema';

import { mergeState } from 'mutators/mergeState/mergeState';
import { mergeStateUIFilterForm } from 'mutators/mergeStateUIFilterForm/mergeStateUIFilterForm';
import { mergeStateUIHistoryPanel } from 'mutators/mergeStateUIHistoryPanel/mergeStateUIHistoryPanel';

import { getFilterDateFromQueryIdDate } from 'helpers/date/getFilterDateFromQueryIdDate/getFilterDateFromQueryIdDate';

export const fetchLogsByQueryId = createService(async function fetchLogsByQueryId(
    { queryId }: { queryId: string },
    { setState, getState, request },
) {
    setState(
        mergeStateUIHistoryPanel(getState(), {
            selectedQueryId: queryId,
        }),
    );
    setState(
        mergeState(getState(), {
            isPageDataLoadingByQueryId: true,
        }),
    );

    const result = await request.get<HistoryRequestSchema>(`/logviewer/query/${queryId}`);

    const formData = {
        ...result.request,
        from: getFilterDateFromQueryIdDate(result.request.from),
        to: getFilterDateFromQueryIdDate(result.request.to),
    };

    setState(
        mergeState(getState(), {
            isPageDataLoadingByQueryId: false,
            logs: result.response,
            savedForm: {
                logType: result.logName,
                form: formData,
            },
        }),
    );

    setState(
        mergeStateUIFilterForm(getState(), {
            logType: result.logName,
            ...formData,
        }),
    );
});
