import { createService } from 'state/createService/createService';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';
import { getUIFilterFormConditions } from 'selectors/ui/getUIFilterFormConditions/getUIFilterFormConditions';

export const addUIFilterFormCondition = createService(function addUIFilterFormCondition(
    { column, value }: { column: string; value: string },
    { setState, getState },
) {
    let state = getState();
    let filterForm = getUIFilterForm(state);
    let conditions = getUIFilterFormConditions(state);
    let newConditions = { ...conditions };
    let preparedValue = value.replace(/(\s|,)/g, '_')

    if (!newConditions[column]) {
        newConditions[column] = preparedValue;
    } else {
        newConditions[column] += ' ' + preparedValue;
    }

    setState(
        mergeStateUI(state, {
            filterForm: {
                ...filterForm,
                conditions: newConditions,
            },
        }),
    );
});
