import { createService } from 'state/createService/createService';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';
import { getUIFilterFormConditions } from 'selectors/ui/getUIFilterFormConditions/getUIFilterFormConditions';

export const changeUIFilterFormConditions = createService(function changeUIFilterFormConditions(
    { column }: { column: string },
    { setState, getState },
) {
    let state = getState();
    let filterForm = getUIFilterForm(state);
    let conditions = getUIFilterFormConditions(state);
    let newConditions = { ...conditions };

    if (conditions[column] !== undefined) {
        delete newConditions[column];
    } else {
        newConditions[column] = '';
    }

    setState(
        mergeStateUI(state, {
            filterForm: {
                ...filterForm,
                conditions: newConditions,
            },
        }),
    );
});
