import { createService } from 'state/createService/createService';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';
import { getUIFilterFormConditions } from 'selectors/ui/getUIFilterFormConditions/getUIFilterFormConditions';

export const replaceUIFilterFormCondition = createService(function replaceUIFilterFormCondition(
    { column, value }: { column: string; value: string },
    { setState, getState },
) {
    let state = getState();
    let filterForm = getUIFilterForm(state);
    let conditions = getUIFilterFormConditions(state);
    let newConditions = { ...conditions };
    newConditions[column] = value;

    setState(
        mergeStateUI(state, {
            filterForm: {
                ...filterForm,
                conditions: newConditions,
            },
        }),
    );
});
