import { createService } from 'state/createService/createService';

import { UIFilterFormSchema, UISchema } from 'schema/ui/UISchema';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';

export const updateUIFilterForm = createService(function updateUICampaignForm(
    newForm: Partial<UIFilterFormSchema>,
    { setState, getState },
) {
    let state = getState();
    let filterForm = getUIFilterForm(state);

    let payload: Partial<UISchema> = {
        filterForm: {
            ...filterForm,
            ...newForm,
        },
    };

    if (newForm.uncollapsedValues !== undefined) {
        payload.viewInfo = {};
    }

    setState(mergeStateUI(state, payload));
});
