import { createService } from 'state/createService/createService';

import { LogSourceSchema } from 'schema/logs/LogSourceSchema';

import { mergeState } from 'mutators/mergeState/mergeState';

import cachedLogs from './data.json';

interface Response {
    logs: LogSourceSchema[];
}

function getLogsConfig(response: Response): Dict<LogSourceSchema> {
    return response.logs.reduce((result, source: LogSourceSchema) => {
        result[source.name] = source;

        return result;
    }, {} as Dict<LogSourceSchema>);
}

export const loadConfig = createService(async function loadConfig(_: void, { setState, request, getState }) {
    try {
        let data = await request.get<Response>('/logviewer/info');

        setState(
            mergeState(getState(), {
                logsConfig: getLogsConfig(data),
            }),
        );
    } catch (e) {
        setState(
            mergeState(getState(), {
                logsConfig: getLogsConfig(cachedLogs),
            }),
        );
    }
});
