import { createService } from 'state/createService/createService';

import { HistoryItemSchema, HistoryRequestsList } from 'schema/history/HistorySchema';

import { mergeStateHistory } from 'mutators/mergeStateHistory/mergeStateHistory';

import { getHistory } from 'selectors/history/getHistory/getHistory';

import { EMPTY_HISTORY } from 'enums/history';

export const loadHistory = createService(async function loadHistory(
    { loadNextChunk }: { loadNextChunk: boolean },
    { setState, getState, request },
) {
    const history = getHistory(getState()) || EMPTY_HISTORY;
    const { requestsList: oldRequestsList, limit, startBefore: oldStartBefore } = history;
    let requestsList = loadNextChunk ? oldRequestsList : [];
    let startBefore: undefined | number = undefined;

    if (loadNextChunk && oldRequestsList.length) {
        startBefore = (oldRequestsList[oldRequestsList.length - 1] as HistoryItemSchema).startTime - 1;
    }

    // Если уже была попытка загрузить данные старше этого времени, но ничего не загрузилось
    // прячем кнопку
    if (startBefore && oldStartBefore === startBefore) {
        return setState(
            mergeStateHistory(getState(), {
                isLoadNextChunkButtonHidden: true,
            }),
        );
    }

    setState(
        mergeStateHistory(getState(), {
            startBefore,
            requestsList,
            isLoading: true,
        }),
    );

    const startBeforeString = startBefore ? `&startBefore=${startBefore}` : '';
    const newRequestsList = await request.get<HistoryRequestsList>(`/logviewer/queries?limit=${limit}${startBeforeString}`);

    setState(
        mergeStateHistory(getState(), {
            requestsList: requestsList.concat(newRequestsList),
            isLoading: false,
        }),
    );
});
