import { createService } from 'state/createService/createService';

import { UIPanelType } from 'schema/ui/UISchema';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { loadHistory } from 'services/loadHistory/loadHistory';

export const switchUIPanel = createService(function switchUIPanel(
    { selectedPanel }: { selectedPanel: UIPanelType },
    { setState, getState, dispatch },
) {
    let state = getState();

    setState(
        mergeStateUI(state, {
            selectedPanel,
        }),
    );

    if (selectedPanel === UIPanelType.History) {
        return dispatch(loadHistory({ loadNextChunk: false }));
    }
});
