import { createService } from 'state/createService/createService';

import { HistoryRequestSchema } from 'schema/history/HistorySchema';

import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';

import { copyToClipboard } from 'helpers/common/copyToClipboard/copyToClipboard';
import { showMessage } from 'helpers/notification/showMessage/showMessage';

export const shareShortLinkByQueryId = createService(async function shareShortLinkByQueryId(
    { queryId }: { queryId: string },
    { setState, getState, request },
) {
    setState(
        mergeStateUI(getState(), {
            preparingToShareQueryId: queryId,
        }),
    );

    try {
        const shortLink = `${location.protocol}//${location.host}/logviewer/short/v2/${queryId}`;
        await copyToClipboard(shortLink);
        await request.post<HistoryRequestSchema>(`/logviewer/query/${queryId}`, { shared: true });
        setState(
            mergeStateUI(getState(), {
                preparingToShareQueryId: undefined,
            }),
        );
        showMessage('Link copied to clipboard', 'success');
    } catch (e) {
        showMessage("Couldn't copy link to clipboard!", 'error');
    }
});
