import { createService } from 'state/createService/createService';

import { mergeState } from 'mutators/mergeState/mergeState';
import { mergeStateUI } from 'mutators/mergeStateUI/mergeStateUI';
import { mergeStateUIFilterForm } from 'mutators/mergeStateUIFilterForm/mergeStateUIFilterForm';

import { getFilterFormFromUI } from 'helpers/form/getFilterFormFromUI/getFilterFormFromUI';
import { validateFilterForm } from 'helpers/form/validateFilterForm/validateFilterForm';

import { getUIFilterForm } from 'selectors/ui/getUIFilterForm/getUIFilterForm';

import { fetchLogs } from 'services/fetchLogs/fetchLogs';

import { EMPTY_LOGS } from 'enums/logs';

export const showLogs = createService(async function showLogs(
    { signal }:{ signal: AbortSignal },
    { setState, getState, dispatch }
) {
    const form = getUIFilterForm(getState());

    if (!form.logType) {
        return;
    }

    const error = validateFilterForm(form);

    if (error) {
        setState(
            mergeStateUIFilterForm(getState(), {
                error,
            }),
        );

        return;
    }

    let state = mergeState(getState(), {
        logs: {
            ...EMPTY_LOGS,
            _loading: true,
        },
    });

    state = mergeStateUI(state, {
        filterForm: {
            ...form,
            error: undefined,
        },
        viewInfo: {},
        hiddenColumns: {},
        isSqlBlockVisible: false,
    });

    setState(state);

    const formInput = getFilterFormFromUI(form);

    await dispatch(fetchLogs({ input: formInput, signal }));
});
