import { createService } from 'state/createService/createService';

import { FormSchema } from 'schema/form/FormSchema';

import { mergeState } from 'mutators/mergeState/mergeState';

import { getLogs } from 'selectors/logs/getLogs/getLogs';
import { getSavedForm } from 'selectors/logs/getSavedForm/getSavedForm';

import { fetchLogs } from 'services/fetchLogs/fetchLogs';

import { EMPTY_LOGS } from 'enums/logs';

export const showLogsPage = createService(async function showLogsPage(
    { page, signal }: { page: number, signal?: AbortSignal },
    { setState, getState, dispatch },
) {
    let form = getSavedForm(getState());
    let currentLogs = getLogs(getState()) || EMPTY_LOGS;

    if (!form) {
        return;
    }

    let newForm: FormSchema = {
        logType: form.logType,
        form: {
            ...form.form,
        },
    };

    newForm.form.offset = (page - 1) * newForm.form.limit;

    setState(
        mergeState(getState(), {
            logs: {
                ...currentLogs,
                _loading: true,
            },
            savedForm: newForm,
        }),
    );

    await dispatch(fetchLogs({ input: newForm, signal }));
});
