import { applyMiddleware, compose, createStore, MiddlewareAPI, PreloadedState, Store } from 'redux';

import { RequestInterface } from 'network/RequestInterface';
import { ReduxAction, ServiceAction } from 'state/redux/redux';

export function createReduxStore<S>(state: PreloadedState<S>, clientRequest?: RequestInterface): Store<S> {
    let store: Store<S>;

    function reducer(state: S | undefined, action: ReduxAction<S>) {
        if (action.payload) {
            state = action.payload;
        }

        return state as S;
    }

    function setState(payload: S, type: string = 'setState') {
        store.dispatch({ type, payload });
    }

    function middleware({ dispatch, getState }: MiddlewareAPI) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return (next: any) => (action: S | undefined | ServiceAction<any>) => {
            if (typeof action === 'function') {
                // @ts-ignore
                return action({
                    dispatch,
                    getState,
                    setState,
                    request: clientRequest,
                });
            }

            return next(action);
        };
    }

    let enhancer = applyMiddleware(middleware);

    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let composeEnhancers = (window as any).__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
    enhancer = composeEnhancers(enhancer);

    store = (createStore<S, ReduxAction<S>, {}, {}>(reducer, state, enhancer) as unknown) as Store<S>;

    return store;
}
