import { ServiceAction, ServiceCallback, ServiceCreator } from 'state/redux/redux';

export function createService<Input, Output>(callback: ServiceCallback<Input, Output>): ServiceCreator<Input, Output> {
    return function (data: Input): ServiceAction<Output> {
        return function (options) {
            let originalSetState = options.setState;

            options.setState = function (state, type) {
                if (type) {
                    throw new Error('Do not use second argument in setState!');
                }

                originalSetState(state, callback.name);
            };

            return callback(data, options);
        };
    };
}
