import { Action } from 'redux';

import { RequestInterface } from 'network/RequestInterface';

import { StateSchema } from 'schema/state/StateSchema';

export type ReduxAction<S> = { payload: S } & Action;

export type ReduxAnyAction<I> = ReduxAction<I> | ServiceAction<I>;

export interface ServiceActionOptions {
    dispatch<Output>(action: ServiceAction<Output>): Output;

    getState(): StateSchema;

    setState(state: StateSchema, type?: string): void;

    request: RequestInterface;
}

export interface ServiceAction<Output> {
    (options: ServiceActionOptions): Output;
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export interface UnpackedConnect<I = any, O = any> {
    dispatch(action: ServiceCallback<I, O>): O;
}

export type ServiceCallback<Input, Output> = (data: Input, options: ServiceActionOptions) => Output;

export interface ServiceCreator<Input, Output> {
    (data: Input): ServiceAction<Output>;
}

export interface Store {
    dispatch<Output>(action: ServiceAction<Output>): Output;

    getState(): StateSchema;

    subscribe(callback: () => void): () => void;
}

export interface ServiceDispatch {
    <TReturnType>(serviceAction: ServiceAction<TReturnType>): TReturnType;
    <A extends Action>(action: A): A;

    // This overload is the union of the two above
    <TReturnType, TAction extends Action>(action: TAction | ServiceAction<TReturnType>): TAction | TReturnType;
}
