if [ -z "$1" ]
then
  echo "Please supply a subdomain to create a certificate for";
  echo "e.g. mysite.localhost"
  exit;
fi

if [ -f secrets/device.key ]; then
  KEY_OPT="-key"
else
  KEY_OPT="-keyout"
fi

DOMAIN=$1
COMMON_NAME=${2:-$1}

SUBJECT="/C=CA/ST=None/L=NB/O=None/CN=$COMMON_NAME"
NUM_OF_DAYS=999

openssl req -new -newkey rsa:2048 -sha256 -nodes $KEY_OPT secrets/device.key -subj "$SUBJECT" -out secrets/device.csr

cat <<EOF | sed s/%%DOMAIN%%/$COMMON_NAME/g > /tmp/__v3.ext
authorityKeyIdentifier=keyid,issuer
basicConstraints=CA:FALSE
keyUsage = digitalSignature, nonRepudiation, keyEncipherment, dataEncipherment
subjectAltName = @alt_names

[alt_names]
DNS.1 = %%DOMAIN%%
DNS.2 = *.%%DOMAIN%%
EOF

openssl x509 -req -in secrets/device.csr -CA secrets/rootCA.pem -CAkey secrets/rootCA.key -CAcreateserial -out secrets/device.crt -days $NUM_OF_DAYS -sha256 -extfile /tmp/__v3.ext

mv secrets/device.csr secrets/$DOMAIN.csr
cp secrets/device.crt secrets/$DOMAIN.crt

# remove temp file
rm -f secrets/device.crt;
