package ru.yandex.direct.logviewer;

import java.util.Locale;

import ru.yandex.direct.common.jetty.JettyConfig;
import ru.yandex.direct.common.jetty.JettyLauncher;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;

public final class LogViewerApp {
    private LogViewerApp() {
        // deny instantiation
    }

    public static void main(String[] args) throws Exception {
        Locale.setDefault(new Locale("en"));
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(LogViewerApp.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, "direct.logviewer");

        DirectConfig conf = DirectConfigFactory.getConfig();
        JettyConfig jettyConfig = new JettyConfig(conf.getBranch("jetty"));

        JettyLauncher.server(jettyConfig)
                .withDefaultWebApp(LogViewerApp.class.getClassLoader(), "/")
                .run();
    }
}
