package ru.yandex.direct.logviewer.auth;

import ru.yandex.direct.web.auth.blackbox.BlackboxCookieAuthRequest;
import ru.yandex.direct.web.auth.blackbox.BlackboxCookieCredentials;

/**
 * Расширяет токен на запрос аутентификации BlackboxCookieAuthRequest, добавляя к нему
 * информацию о том, какой паспорт следует использовать для входа: внешний (yandex.ru) или внутренний (yandex-team).
 */
public class LogviewerCookieAuthRequest extends BlackboxCookieAuthRequest {
    private final BlackboxType blackboxType;

    public LogviewerCookieAuthRequest(BlackboxCookieCredentials credentials,
                                      String tvmTicket,
                                      BlackboxType blackboxType) {
        super(credentials, tvmTicket);
        this.blackboxType = blackboxType;
    }

    public BlackboxType getBlackboxType() {
        return blackboxType;
    }
}
