package ru.yandex.direct.logviewer.auth;

import java.util.Collection;
import java.util.List;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

/**
 * Объект аутентификации, создаваемый при заходе через внутренний (yandex-team) паспорт.
 */
public class LogviewerInternalBlackboxAuthentication implements Authentication {
    private final String login;
    private final List<SimpleGrantedAuthority> authorities;

    public LogviewerInternalBlackboxAuthentication(String login, List<SimpleGrantedAuthority> authorities) {
        this.login = login;
        this.authorities = authorities;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return authorities;
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @Override
    public Object getDetails() {
        return null;
    }

    @Override
    public Object getPrincipal() {
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    @Override
    public String getName() {
        return login;
    }
}
