package ru.yandex.direct.logviewer.configuration;

import org.springframework.context.annotation.AdviceMode;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;

/**
 * <code>@EnableGlobalMethodSecurity</code> prePostEnabled attribute enables
 * expressions in <code>@PreAuthorize</code>-annotations
 */
@EnableGlobalMethodSecurity(securedEnabled = true, prePostEnabled = true, mode = AdviceMode.PROXY)
public class AuthorizationConfiguration extends GlobalMethodSecurityConfiguration {

    /**
     * Disables authentication at authorization-time.
     * Authentication must be completed before.
     */
    @Override
    protected AuthenticationManager authenticationManager() throws Exception {
        return (authentication -> authentication);
    }
}
