package ru.yandex.direct.logviewer.configuration;

import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.AccessDeniedException;

@ControllerAdvice
public class ExceptionHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlerController.class);

    @ExceptionHandler(AccessDeniedException.class)
    @ResponseBody
    public ResponseEntity<String> accessDenied(AccessDeniedException exception) {
        logger.error("Access denied", exception);
        return new ResponseEntity<>("Access denied", HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(EofException.class)
    @ResponseBody
    public ResponseEntity<String> eofErrorHandler(Exception e) {
        // Jetty EOF -- это QuietException, который обозначает разрыв соединения с клиентской стороны. Логируем как INFO
        logger.info("Client closed request", e);
        return ResponseEntity.status(ru.yandex.misc.io.http.HttpStatus.SC_499_CLIENT_CLOSED_REQUEST).build();
    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public ResponseEntity<String> internalServerError(Exception exception) {
        logger.error("Internal server error", exception);
        return new ResponseEntity<>("internal server error", HttpStatus.INTERNAL_SERVER_ERROR);
    }
}
