package ru.yandex.direct.logviewer.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.common.configuration.FrontDbYdbConfiguration;
import ru.yandex.direct.common.configuration.LoggingConfiguration;
import ru.yandex.direct.common.logging.LoggingSettings;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.uac.grut.EmptyGrutContext;
import ru.yandex.direct.core.entity.uac.grut.GrutContext;
import ru.yandex.direct.integrations.configuration.IntegrationsConfiguration;

@Configuration
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.logviewer",
                "ru.yandex.direct.logviewercore"
        },
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CommonConfiguration.class,
        CoreConfiguration.class,
        IntegrationsConfiguration.class,
        LoggingConfiguration.class,
        FrontDbYdbConfiguration.class,
        LogviewerYdbConfiguration.class,
})
public class LogViewerConfiguration {
    @Bean
    public LoggingSettings loggingDefaults() {
        return new LoggingSettings(1024 * 1024, 1024 * 1024);
    }

    @Bean
    public GrutContext grutContext() {
        return new EmptyGrutContext();
    }
}
