package ru.yandex.direct.logviewer.logging;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.common.logging.LogRecord;
import ru.yandex.direct.rbac.RbacRole;

@SuppressWarnings({"FieldCanBeLocal", "unused", "WeakerAccess"})
public class LogviewerLogRecord extends LogRecord {

    private static final String LOG_SERVICE_NAME = "direct.java.logviewer";

    @JsonProperty("role")
    private RbacRole operatorRole;

    @JsonProperty("yandexuid")
    private String yandexUid;

    public LogviewerLogRecord(long requestId, HttpServletRequest request) {
        super(requestId, request);
    }

    public void setOperatorRole(RbacRole operatorRole) {
        this.operatorRole = operatorRole;
    }

    public void setYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    @Override
    public String getService() {
        return LOG_SERVICE_NAME;
    }
}
