package ru.yandex.direct.logviewer.logging;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.logging.LogRecordHolder;
import ru.yandex.direct.common.logging.LoggingFilter;
import ru.yandex.direct.common.logging.LoggingSettings;
import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.tracing.Trace;

@Component
@ParametersAreNonnullByDefault
public class LogviewerLoggingFilter extends LoggingFilter<LogviewerLogRecord> {

    private static final String LOGGER_NAME = "PPCLOG_CMD.log";

    @Autowired
    public LogviewerLoggingFilter(LoggingSettings loggingDefaults,
                                  LogRecordHolder<LogviewerLogRecord> logRecordHolder) {
        super(LOGGER_NAME, loggingDefaults, logRecordHolder);
    }

    @Override
    protected void initLogRecord(long requestId, HttpServletRequest requestToUse) {
        LogviewerLogRecord logviewerLogRecord = createLogRecord(requestToUse);
        logRecordHolder.setLogRecord(logviewerLogRecord);
    }

    private LogviewerLogRecord createLogRecord(HttpServletRequest httpRequest) {
        LogviewerLogRecord logviewerLogRecord = new LogviewerLogRecord(Trace.current().getSpanId(), httpRequest);

        String yandexUid = HttpUtil.getCookieValue("yandexuid", httpRequest).orElse(null);
        logviewerLogRecord.setYandexUid(yandexUid);

        fillAuthenticationInfo(logviewerLogRecord);

        return logviewerLogRecord;
    }

    private void fillAuthenticationInfo(LogviewerLogRecord logRecord) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof DirectAuthentication) {
            DirectAuthentication directAuthentication = (DirectAuthentication) authentication;
            logRecord.setOperatorId(directAuthentication.getOperator().getUid());
            logRecord.setOperatorRole(directAuthentication.getOperator().getRole());
        }
    }
}
