#!/bin/bash
clickhouse-client -h ppchouse.yandex.net -u readonly -q "select method, quantilesExact(0.95)(ela_s)[1] as ela from (SELECT log_date, method, quantilesExact(0.90)(ela)[1] as ela_s FROM default.trace WHERE log_date >= today() - 90 and log_date < today() and toHour(log_time) >= 8 and toHour(log_time) <= 23 and toDayOfWeek(log_time) < 6 and service in ('direct.web', 'direct.perl.web') group by method, log_date ORDER BY method, log_date, ela_s) group by method having min(log_date) < today() - 28 order by ela, method format TabSeparated" | perl -lne '$s = $_; $s =~ s/\t\d+\.\d+$//; @nonword = ($s =~ /([^a-zA-Z_.])/g); @digits = ($s =~ /\d/g); print if $s =~ /^[a-zA-Z]/ and not $s =~ /\h/ and scalar @digits < 2 and scalar @nonword < 2' | perl -lane 'BEGIN { @bins = (1, 5, 10, 20, 30, 60, 100, 300) } for (@bins) { if ($F[1]*3 < $_ && !$f) { print "$_\t$F[0]"; $f=1; }}; print "$bins[-1]\t$F[0]" if !$f; $f="";' | sort -t$'\t' -k1,1g -k2,2 | perl -lane 'if ($F[0] == $last_bin) { print "      - $F[1]" } else { print "- max_ela: $F[0]\n  methods:"; $last_bin=$F[0] }'
