package ru.yandex.direct.oneshot.base;

import javax.annotation.Nullable;

import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * @param <S> тип хранимого состояния
 */
public abstract class ShardedIterativeOneshotWithoutInput<S> implements ShardedOneshot<Void, S> {

    @Nullable
    protected abstract S execute(S prevState, int shard);

    @Override
    public final ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }

    @Nullable
    @Override
    public final S execute(Void inputData, S prevState, int shard) {
        return execute(prevState, shard);
    }
}
