package ru.yandex.direct.oneshot.base;

import javax.annotation.Nullable;

import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public abstract class ShardedOneshotWithoutInput implements ShardedOneshot<Void, Void> {

    protected abstract void execute(int shard);

    @Override
    public final ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }

    @Nullable
    @Override
    public final Void execute(Void inputData, Void prevState, int shard) {
        execute(shard);
        return null;
    }
}
