package ru.yandex.direct.oneshot.base;

import javax.annotation.Nullable;

import ru.yandex.direct.oneshot.worker.def.SimpleOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * @param <S> тип хранимого состояния
 */
public abstract class SimpleIterativeOneshotWithoutInput<S> implements SimpleOneshot<Void, S> {

    @Nullable
    protected abstract S execute(@Nullable S prevState);

    @Override
    public final ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }

    @Override
    @Nullable
    public final S execute(Void inputData, @Nullable S prevState) {
        return execute(prevState);
    }
}
