package ru.yandex.direct.oneshot.base;

import javax.annotation.Nullable;

import ru.yandex.direct.oneshot.worker.def.SimpleOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public abstract class SimpleOneshotWithoutInput implements SimpleOneshot<Void, Void> {

    protected abstract void execute();

    @Override
    public final ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }

    @Nullable
    public final Void execute(Void inputData, Void prevState) {
        execute();
        return null;
    }
}
