package ru.yandex.direct.oneshot.base;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.constraint.CommonConstraints;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtTable;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

abstract class YtOneshot<V extends YtInputData> {
    protected final YtProvider ytProvider;

    protected YtOneshot(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
    }

    protected final ItemValidationBuilder<V, Defect> validateYt(V inputData) {
        ItemValidationBuilder<V, Defect> vb = ItemValidationBuilder.of(inputData);

        Set<String> setOfYtClusters = new HashSet<>();
        for (YtCluster c : YtCluster.values()) {
            setOfYtClusters.add(c.getName());
        }
        vb.item(inputData.getYtCluster(), "ytCluster")
                .check(CommonConstraints.notNull())
                .check(CommonConstraints.inSet(setOfYtClusters));

        // если ошиблись с кластером, то проверить существование таблицы не сможем - выходим
        if (vb.getResult().hasAnyErrors()) {
            return vb;
        }
        YtCluster ytCluster = YtCluster.parse(inputData.getYtCluster());
        vb.item(inputData.getTablePath(), "tablePath")
                .check(CommonConstraints.notNull())
                .check(fromPredicate(tablePath -> ytProvider.getOperator(ytCluster).exists(new YtTable(tablePath)),
                        CommonDefects.objectNotFound()));
        return vb;
    }
}
