package ru.yandex.direct.oneshot.configuration;

import java.nio.file.Files;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.autobudget.restart.AutobudgetRestartConfiguration;
import ru.yandex.direct.bstransport.yt.configuration.BsTransportYtConfiguration;
import ru.yandex.direct.common.configuration.FrontDbYdbConfiguration;
import ru.yandex.direct.communication.config.CommunicationConfiguration;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.campaign.container.AffectedCampaignIdsContainer;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.RequestCampaignAccessibilityCheckerProvider;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.ess.client.EssClientConfiguration;
import ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration;
import ru.yandex.direct.oneshot.app.OneshotVersionControl;
import ru.yandex.direct.oneshot.core.configuration.OneshotCoreConfiguration;
import ru.yandex.direct.oneshot.core.entity.oneshot.repository.OneshotLaunchDataRepository;
import ru.yandex.direct.oneshot.core.entity.oneshot.repository.OneshotLaunchRepository;
import ru.yandex.direct.oneshot.core.entity.oneshot.repository.OneshotRepository;
import ru.yandex.direct.oneshot.worker.ExecutionWorker;
import ru.yandex.direct.oneshot.worker.OneshotExecuteTaskFactory;
import ru.yandex.direct.oneshot.worker.ValidationWorker;
import ru.yandex.direct.tracing.TraceHelper;
import ru.yandex.direct.utils.io.FileUtils;

import static ru.yandex.direct.core.configuration.CoreConfiguration.ACCESSIBLE_CAMPAIGN_CHEKER_PROVIDER;

@Configuration
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.oneshot.oneshots",
                "ru.yandex.direct.oneshot.worker",
                "ru.yandex.direct.oneshot.app"
        },
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CoreConfiguration.class,
        OneshotCoreConfiguration.class,
        BsTransportYtConfiguration.class,
        EssLogicProcessorConfiguration.class,
        AutobudgetRestartConfiguration.class,
        EssClientConfiguration.class,
        FrontDbYdbConfiguration.class,
        CommunicationConfiguration.class,
})
public class AppConfiguration {

    private static final Integer IDLE_MILLIS = 5_000;

    @Bean
    public ValidationWorker validationWorker(ApplicationContext appContext,
                                             OneshotRepository oneshotRepository,
                                             OneshotLaunchRepository launchRepository,
                                             DslContextProvider dslContextProvider,
                                             OneshotVersionControl oneshotVersionControl,
                                             TraceHelper traceHelper) {
        return new ValidationWorker(appContext, oneshotRepository, launchRepository, dslContextProvider,
                oneshotVersionControl, traceHelper, IDLE_MILLIS);
    }

    @Bean
    public ExecutionWorker executionWorker(OneshotRepository oneshotRepository,
                                           OneshotLaunchRepository launchRepository,
                                           OneshotLaunchDataRepository launchDataRepository,
                                           DslContextProvider dslContextProvider,
                                           OneshotVersionControl oneshotVersionControl,
                                           OneshotExecuteTaskFactory taskFactory,
                                           TraceHelper traceHelper) {
        return new ExecutionWorker(oneshotRepository, launchRepository, launchDataRepository,
                dslContextProvider, oneshotVersionControl, taskFactory, traceHelper, IDLE_MILLIS);
    }

    @Bean
    public MongoClient mongoClient(DirectConfig directConfig) {
        try {
            var mongoString = Files.readString(FileUtils.expandHome(
                    directConfig.getBranch("mongo").getString("token_path"))).strip();
            return new MongoClient(new MongoClientURI(mongoString));
        } catch (Exception ex) {
            // может выпасть при локальном запуске, если на локальной машине не будет токена по пути
            // ~/direct-tokens/mongo_canvas-devtest
            return new MongoClient();
        }
    }

    @Bean
    public AffectedCampaignIdsContainer affectedCampaignIdsContainer() {
        return new AffectedCampaignIdsContainer();
    }

    @Bean(name = ACCESSIBLE_CAMPAIGN_CHEKER_PROVIDER)
    public RequestCampaignAccessibilityCheckerProvider accessibilityCheckerProvider() {
        return new RequestCampaignAccessibilityCheckerProvider();
    }
}
