package ru.yandex.direct.oneshot.debug;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

public class OneshotParamsDebug {
    @Parameter(
            names = {"-c"},
            description = "Class name of oneshot to run (fully-qualified with package name)",
            required = true
    )
    public String className;

    @Parameter(
            names = {"-i"},
            description = "Input data (JSON)",
            required = true
    )
    public String inputData;

    @Parameter(
            names = {"-s"},
            description = "Initial state (JSON)"
    )
    public String state;

    @Parameter(
            names = {"-r"},
            description = "Retries count, default 0"
    )
    public int retries = 0;

    @Parameter(
            names = {"--shards"},
            description = "Comma separated list of shards for running sharded oneshot",
            variableArity = true
    )
    public List<Integer> shards = new ArrayList<>();
}
