package ru.yandex.direct.oneshot.oneshots.addIsFrontpageToPricePackages;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.repository.PricePackageRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.oneshot.base.SimpleOneshotWithoutInput;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;

@Component
@Approvers({"alex-kulakov", "andreypav", "eboguslavskaya"})
@Multilaunch
public class AddIsFrontpageToPricePackagesOneshot extends SimpleOneshotWithoutInput {

    private final PricePackageRepository pricePackageRepository;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public AddIsFrontpageToPricePackagesOneshot(PricePackageRepository pricePackageRepository, DslContextProvider dslContextProvider) {
        this.pricePackageRepository = pricePackageRepository;
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    protected void execute() {
        List<PricePackage> pricePackagesToChange = pricePackageRepository.getAllPricePackages()
                .stream()
                .filter(pricePackage -> pricePackage.isFrontpagePackage() && !pricePackage.getIsFrontpage())
                .collect(Collectors.toList());
        var changes = pricePackagesToChange.stream()
                .map(pricePackage -> new ModelChanges<PricePackage>(pricePackage.getId(), PricePackage.class)
                        .process(true, PricePackage.IS_FRONTPAGE)
                        .applyTo(pricePackage))
                .collect(Collectors.toList());
        pricePackageRepository.updatePricePackages(dslContextProvider.ppcdict(), changes);
    }
}
