package ru.yandex.direct.oneshot.oneshots.addspravcounter.repository;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.sprav.model.Permalink;
import ru.yandex.direct.oneshot.oneshots.addspravcounter.ytmodels.generated.YtPermalinks;
import ru.yandex.direct.oneshot.oneshots.addspravcounter.ytmodels.generated.YtPermalinksRow;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;

import static ru.yandex.direct.oneshot.oneshots.addspravcounter.ytmodels.generated.YtDbTables.PERMALINKS;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

/*
  Получение данных из таблицы
  https://yt.yandex-team.ru/hahn/navigation?path=//home/altay/sprav_metrika/current-state/permalinks&
 */
@Repository
@ParametersAreNonnullByDefault
public class SpravYtRepository {
    private final YtProvider ytProvider;

    @Autowired
    public SpravYtRepository(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
    }

    /**
     * Получить пермалники для промежутка id'шников
     */
    public List<Permalink> getPermalinks(long minId, long maxId) {
        YtCluster cluster = YtCluster.HAHN;
        List<Permalink> result = new ArrayList<>();
        ytProvider.getOperator(cluster).readTableByKeyRange(PERMALINKS,
                row -> result.add(convertFromYt(row)),
                new YtPermalinksRow(List.of(
                        YtPermalinks.PERMALINK,
                        YtPermalinks.NAME,
                        YtPermalinks.METRIKA_COUNTER,
                        YtPermalinks.OWNER_METRIKA_COUNTER)),
                YTree.unsignedLongNode(minId),
                YTree.unsignedLongNode(maxId + 1));
        return result;
    }

    private static Permalink convertFromYt(YtPermalinksRow row) {
        Long metrikaCounter = ifNotNull(row.getMetrikaCounter(), Long::valueOf);
        Long ownerMetrikaCounter = ifNotNull(row.getOwnerMetrikaCounter(), Long::valueOf);
        return new Permalink()
                .withPermalinkId(row.getPermalink())
                .withName(row.getName())
                .withOwnerMetrikaCounter(ownerMetrikaCounter)
                .withMetikaCounter(metrikaCounter);

    }
}
