package ru.yandex.direct.oneshot.oneshots.addspravcounter.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.sprav.model.Permalink;
import ru.yandex.direct.oneshot.oneshots.addspravcounter.repository.SpravYtRepository;

@Service
@ParametersAreNonnullByDefault
public class SpravService {
    private final SpravYtRepository spravYtRepository;

    @Autowired
    public SpravService(SpravYtRepository spravYtRepository) {
        this.spravYtRepository = spravYtRepository;
    }

    public Map<Long, Long> getCounterIdByPermalinkId(Set<Long> permalinkIds) {
        List<Permalink> permalinks = spravYtRepository.getPermalinks(Collections.min(permalinkIds),
                Collections.max(permalinkIds));

        return StreamEx.of(permalinks)
                .mapToEntry(Permalink::getPermalinkId, Permalink::getMetikaCounter)
                .filterKeys(permalinkIds::contains)
                .nonNullValues()
                .toMap();
    }

}
