package ru.yandex.direct.oneshot.oneshots.bsexport;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bs.export.queue.repository.BsExportSpecialsRepository;
import ru.yandex.direct.dbschema.ppc.enums.BsExportSpecialsParType;
import ru.yandex.direct.dbutil.QueryWithoutIndex;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.base.SimpleOneshotWithoutInput;
import ru.yandex.direct.oneshot.worker.def.Approvers;

import static ru.yandex.direct.dbschema.ppc.Tables.BS_EXPORT_SPECIALS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

@Component
@Approvers({"zhur", "pavryabov"})
public class DeleteGarbageFromBsExportSpecials  extends SimpleOneshotWithoutInput {
    private static final Logger logger = LoggerFactory.getLogger(DeleteGarbageFromBsExportSpecials.class);

    private final DslContextProvider dslContextProvider;
    private final BsExportSpecialsRepository repository;
    private final ShardHelper shardHelper;


    @Autowired
    public DeleteGarbageFromBsExportSpecials(DslContextProvider dslContextProvider,
                                             BsExportSpecialsRepository repository, ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.repository = repository;
        this.shardHelper = shardHelper;
    }

    @Override
    protected void execute() {
        logger.info("Start processing");
        shardHelper.dbShards().forEach(this::executeInShard);
    }

    @QueryWithoutIndex("запрос поверх небольшой таблицы")
    private Void executeInShard(Integer shard) {
        logger.info("Start processing shard {}", shard);

        Map<Long, BsExportSpecialsParType> garbage = dslContextProvider.ppc(shard)
                .select(BS_EXPORT_SPECIALS.CID, BS_EXPORT_SPECIALS.PAR_TYPE)
                .from(BS_EXPORT_SPECIALS)
                .leftJoin(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BS_EXPORT_SPECIALS.CID))
                .where(CAMPAIGNS.CID.isNull())
                .fetchMap(BS_EXPORT_SPECIALS.CID, BS_EXPORT_SPECIALS.PAR_TYPE);
        logger.info("Records without campaign: {}", garbage);
        if (!garbage.isEmpty()) {
            logger.info("Deleting records");
            repository.remove(shard, garbage.keySet());
        } else {
            logger.info("Nothing to delete");
        }

        return null;
    }
}
